% ScriptAuditSCLUT

% Esta simulao carrega e configura (de acordo com o Number of Bits - NOB) uma LUT catica e a simula
% por um longo tempo com uma entrada aleatria que  amostrada com um perodo igual a LongRun (A simulao
% completa comea em startime = 0  e termina em stoptime = Cycles*Long_Run*size(Counter_Values,2) = 33600).
% Observa-se que determinada entrada (Input)  simulada X vezes (X = Cycles_Repetition = 3), e as respectivas saidas (Output)
% so salvas nas colunas da Conferation_Table. 
% A coluna 2 da Conferation_Table deve ser igual a zero indicando que todas as Output relacionadas a uma dada Input so iguais.
% Este script eh muito parecido com aquele existente na pasta "D:\Elvio\Educao_Lite\TUD_PhD_Files_Lite_2011\20100914 SC-LUT 512\16 LUT Auditoria"
clear

NOB = 11;

cd ..
cd '90 Configuration Data'
	eval(['load NumberOfBits_', num2str(NOB), '_Bits']);
    eval(['load PRM_', num2str(NOB), '_Bits']);
    eval(['load Slices_', num2str(NOB), '_Bits']);
cd ..
cd '96 LUT Auditoria'

TimeStart = datevec(now); % Its is a 6x1 vector containing:  [Year Month Day Hour Minute Second]

Counter_Initial_Value = 0;
Count_To_Value = power(2,32)-11;
Factors = factor(Count_To_Value-Counter_Initial_Value);   % O comando factors é utilizado para calcular os fatores primos de um número inteiro.
S = size(Factors,2);    % Factors = factor(60) = [2, 2, 3, 5]; S = size(Factors,2) = 4 
Counter_Step = Factors(S)*Factors(S-1);   % Counter_Step = Factors(S)*Factors(S-1) = Factors(4)*Factors(3) = 5*3 = 15 

Counter_Values = Counter_Initial_Value : Counter_Step : Count_To_Value;
Cycles = 7;

Long_Run = 800; % The reference value should be 800, the time necessary for full dispersion
binpoint = max(Slices(:,3))+8;
numberbits = max(Slices(:,3))+33;
latenciamultiplier = 5;
Cycles_Repetition = 3; % It measures how many time a given imput is randonly repeted. Cycles_Repetition must be a Natural number between 1 and 7. Each picture has a number os graphs equal to Cycles_Repetition

startime = 0;
stepsize = 0.01;
Period = (1/(latenciamultiplier*stepsize))*Long_Run;
stoptime = Cycles*Long_Run*size(Counter_Values,2);

Second = 1/86400; % This express one second in terms of a day (one day has 24*60*60 = 86400 seconds)
Speed = 19000/18.5; % 1520/2; % stoptime per minute
TotalTimeForecast = stoptime/Speed; % minutes
TimeEndForecast = datestr(datenum(TimeStart) + TotalTimeForecast*60*Second);
fprintf(1,'The simulation will end at: %s \n', TimeEndForecast);

eval(['mkdir ', DATESTR(datenum(TimeStart),30), '_Files']);
copyfile('ScriptAuditSCLUT.m',['', DATESTR(datenum(TimeStart),30), '_ScriptAuditSCLUT.m']);
copyfile('SprottB_LUT_All_Bits_2.mdl',['', DATESTR(datenum(TimeStart),30), '_SprottB_LUT_All_Bits_2.mdl']);





SimStart = now;            
% open SprottB_LUT_All_Bits_2.mdl
sim('SprottB_LUT_All_Bits_2.mdl');

Colums_Number = 3 + Cycles + 3;
Line_Number = size(Counter_Values,2) + 4;

Conferation_Table = ones(Line_Number,Colums_Number);  % Tabela construida para verificar se o modelo funcona corretament
Conferation_Table = 10001*Conferation_Table;


for L = 1:Line_Number;
    Look_For = Output_LH(find(Input == Input(L+1)))';    % Output_LH é uma das saídas do modelo SprottB_LUT_512_Bits_8.mdl
    Conferation_Table(L,1) = Input(L+1);                % It measures the chaotic equation input 
    Conferation_Table(L,2) = mean(diff(Look_For));      % Column 2 must be equal to zero, except when the input (column 1) is equal to zero itself
    Conferation_Table(L,3) = size(Look_For,2);          % It measures how many times the output is repeated
    Conferation_Table(L,4:size(Look_For,2)+3) = Look_For;
end

% Now that we finished the simulation, we can save the Conference Table
if Conferation_Table(1,1) ~= 10001;
    eval(['Conferation_Table_', DATESTR(datenum(TimeStart),30), ' = Conferation_Table;']);
    filename = (['', DATESTR(datenum(TimeStart),30), '_Conferation_Table.mat']);
    eval(['save(filename,''Conferation_Table_', DATESTR(datenum(TimeStart),30), '*'')']);
end

        
% Now it plays a sound that indicates the end of the simulation
[SimEnd,FqSp,NBits]=wavread('EndOfSimulation.wav');
soundsc(SimEnd,FqSp)
fprintf('\n')
% Now it saves and prints the End of Simulation Time
EndOfSimulation = datestr(now);
fprintf('The simulations Starts on %s\n', datestr(TimeStart));
fprintf('The simulations Ends on %s\n', datestr(EndOfSimulation));
fprintf('\n')
